package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 11.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SUSPEND)
@Description("Валидация JSON-запроса для метода Webpages.Suspend")
public class SuspendJsonValidationTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Массив в поле SelectionCriteria")
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        Object selectionCriteria = new IdsCriteriaMap()
                .withIds(0l).getBean();
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.DYNAMIC_TEXT_AD_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Не массив в поле SelectionCriteria.Ids")
    public void notAnArrayInIdsField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), 0l);
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.DYNAMIC_TEXT_AD_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(SuspendRequestMap.SELECTION_CRITERIA),
                                capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    @Description("Строка внутри массива SelectionCriteria.Ids")
    public void stringInIdsArray() {
        String value = "WrongId";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new String[]{value});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.DYNAMIC_TEXT_AD_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(SuspendRequestMap.SELECTION_CRITERIA),
                                capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    @Description("Массив внутри массива SelectionCriteria.Ids")
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0l}});
        request.put(capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.DYNAMIC_TEXT_AD_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(SuspendRequestMap.SELECTION_CRITERIA),
                                capitalize(IdsCriteriaMap.IDS))));
    }
}
