package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 11.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SUSPEND)
@Description("Проверка обязательных полей в методе Webpages.Suspend")
public class SuspendMandatoryFieldsTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля SelectionCriteria в запросе на остановку условий нацеливания")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Запрос без поля SelectionCriteria.Ids в запросе на остановку условия нацеливания")
    public void requestWithoutIds() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(IdsCriteriaMap.IDS)));
    }
}
