package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 17.12.15.
 * https://st.yandex-team.ru/TESTIRT-7965
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-49484")
public class SuspendStatusBlGeneratedTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long wid;

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        wid = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid, client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps()
                .setStatusBlGenerated(pid, AdgroupsDynamicStatusblgenerated.No);
    }

    @Test
    public void testStatusBlGeneratedAfterSuspendWebpageInActiveGroup() {
        api.userSteps.campaignFakeSteps().makeCampaignActive(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(AdgroupsDynamicStatusblgenerated.No));
    }

    @Test
    public void testStatusBlGeneratedAfterSuspendWebpageInDraftGroup() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(AdgroupsDynamicStatusblgenerated.No));
    }
}
