package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by buhter on 04/09/15.
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Description("Проверка логики метода Webpages.Suspend")
public class SuspendTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<Long> webpageIds;
    private static Long cid;

    @Rule
    public Trashman trashman = new Trashman(api);
    private Long pid;
    private AddResponse response;

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        response = api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name1")
                                .withBid(30000000l)
                                .withConditions(
                                        new WebpageConditionMap()
                                                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY).withArguments("345")),
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name2")
                                .withBid(30000000l)
                                .withConditions(
                                        new WebpageConditionMap()
                                                .withArguments("123")
                                                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                .withOperand(WebpageConditionOperandEnum.DOMAIN))
                ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
        //получаем webpages чтобы узнать Id
        assumeThat("создалась динамическая группа с 3 Webpages'ами", response.getAddResults(), hasSize(2));
    }

    @Test
    public void suspendWithValidParams() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(response.getAddResults().get(0).getId()
                                        )
                        ), ExpectedResult.success()
        );
        List<WebpageGetItem> webpages = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap().withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId(), response.getAddResults().get(1).getId()))
                        .withFieldNames(WebpageFieldEnum.STATE, WebpageFieldEnum.ID)).getWebpages();
        webpages = sort(webpages, on(WebpageGetItem.class).getId());

        assumeThat("было остановлено верное условие", webpages, beanEquivalent(Arrays.asList(
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(response.getAddResults().get(0).getId())
                        .withState(StateEnum.SUSPENDED).getBean(),
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(response.getAddResults().get(1).getId())
                        .withState(StateEnum.ON).getBean())));
    }

    @Test
    public void suspendSeveralWebpagesWithValidParams() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(
                                                response.getAddResults().get(0).getId(),
                                                response.getAddResults().get(1).getId()
                                        )
                        )
                , ExpectedResult.success()
                , ExpectedResult.success()
        );
        List<WebpageGetItem> webpages = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap().withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId(), response.getAddResults().get(1).getId()))
                        .withFieldNames(WebpageFieldEnum.STATE, WebpageFieldEnum.ID)).getWebpages();
        webpages = sort(webpages, on(WebpageGetItem.class).getId());
        assumeThat("было остановлено верное условие", webpages, beanEquivalent(Arrays.asList(
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(response.getAddResults().get(0).getId())
                        .withState(StateEnum.SUSPENDED).getBean(),
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(response.getAddResults().get(1).getId())
                        .withState(StateEnum.SUSPENDED).getBean())));
    }
}
