package ru.yandex.autotests.directapi.keywords.add;

import java.sql.Timestamp;
import java.time.LocalDateTime;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 28.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка у группы времени последнего изменения и статуса синхронизации с БК при добавлении автотаргетинга")
public class AddAutotargetingAdGroupLastChangeAndBsSyncedTest {
    private static LogSteps log = LogSteps.getLogger(AddAutotargetingAdGroupLastChangeAndBsSyncedTest.class);
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static final Timestamp YESTERDAY = Timestamp.valueOf(LocalDateTime.now().minusDays(1).withNano(0));

    private static Long autotargetingId;
    private static Long campaignId;
    private static Long adId;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        log.info("Выставим статусы модерации, синхронизации с БК и дату последнего изменения");

        jooqDbSteps.campaignsSteps().updateCampaigns(
                jooqDbSteps.campaignsSteps().getCampaignById(campaignId)
                        .setStatusmoderate(CampaignsStatusmoderate.Yes)
                        .setStatusbssynced(CampaignsStatusbssynced.Yes)
                        .setLastchange(YESTERDAY)
        );
        jooqDbSteps.adGroupsSteps().updatePhrases(
                jooqDbSteps.adGroupsSteps().getPhrases(adGroupId)
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
                        .setStatusbssynced(PhrasesStatusbssynced.Yes)
                        .setLastchange(YESTERDAY)
        );
        jooqDbSteps.bannersSteps().updateBanners(
                jooqDbSteps.bannersSteps().getBanner(adId)
                        .setStatusshow(BannersStatusshow.Yes)
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setStatusbssynced(BannersStatusbssynced.Yes)
                        .setLastchange(YESTERDAY)
        );

        log.info("Добавим в группу автотаргетинг");
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Test
    public void campaignStatusBsSyncedTest() {
        assertThat("статус синхронизации с БК у кампании после добавления автотаргетинга",
                jooqDbSteps.campaignsSteps().getCampaignById(campaignId).getStatusbssynced(),
                equalTo(CampaignsStatusbssynced.Yes)
        );
    }

    @Test
    public void bannerStatusBsSyncedTest() {
        assertThat("статус синхронизации с БК у баннера после добавления автотаргетинга",
                jooqDbSteps.bannersSteps().getBanner(adId).getStatusbssynced(),
                equalTo(BannersStatusbssynced.Yes)
        );
    }

    @Test
    public void groupStatusBsSyncedTest() {
        assertThat("статус синхронизации с БК у группы после добавления автотаргетинга",
                jooqDbSteps.adGroupsSteps().getPhrases(adGroupId).getStatusbssynced(),
                equalTo(PhrasesStatusbssynced.No)
        );
    }

    @Test
    public void campaignLastChangeTest() {
        assertThat("время последнего изменения кампании после добавления автотаргетинга не изменилось",
                jooqDbSteps.campaignsSteps().getCampaignById(campaignId).getLastchange(),
                equalTo(YESTERDAY)
        );
    }

    @Test
    public void bannerLastChangeTest() {
        assertThat("время последнего изменения баннера после добавления автотаргетинга не изменилось",
                jooqDbSteps.bannersSteps().getBanner(adId).getLastchange(),
                equalTo(YESTERDAY)
        );
    }

    @Test
    public void groupLastChangeTest() {
        assertThat("время последнего изменения группы после добавления автотаргетинга изменилось",
                jooqDbSteps.adGroupsSteps().getPhrases(adGroupId).getLastchange(),
                greaterThan(YESTERDAY)
        );
    }
}
