package ru.yandex.autotests.directapi.keywords.add;


import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 29.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Добавление автотаргетинга в группы, имеющие различные статусы")
@RunWith(Parameterized.class)
public class AddAutotargetingAdGroupStatusesTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public StatusEnum status;

    @Parameterized.Parameter(1)
    public PhrasesStatusmoderate statusModerate;

    @Parameterized.Parameter(2)
    public PhrasesStatuspostmoderate statusPostModerate;

    @Parameterized.Parameter(3)
    public StatusEnum expectedStatus;

    @Parameterized.Parameters(name = "{0} ({1},{2}) => {3}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                        StatusEnum.DRAFT,
                        PhrasesStatusmoderate.New,
                        PhrasesStatuspostmoderate.New,
                        StatusEnum.DRAFT
                },
                {
                        StatusEnum.MODERATION,
                        PhrasesStatusmoderate.Sending,
                        PhrasesStatuspostmoderate.No,
                        StatusEnum.MODERATION
                },
                {
                        StatusEnum.PREACCEPTED,
                        PhrasesStatusmoderate.Sent,
                        PhrasesStatuspostmoderate.Yes,
                        StatusEnum.MODERATION
                },
                {
                        StatusEnum.ACCEPTED,
                        PhrasesStatusmoderate.Yes,
                        PhrasesStatuspostmoderate.Yes,
                        StatusEnum.ACCEPTED
                },
                {
                        StatusEnum.REJECTED,
                        PhrasesStatusmoderate.No,
                        PhrasesStatuspostmoderate.No,
                        StatusEnum.MODERATION
                },
        });
    }

    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps.adGroupsSteps().updatePhrases(
                jooqDbSteps.adGroupsSteps().getPhrases(adGroupId)
                        .setStatusmoderate(statusModerate)
                        .setStatuspostmoderate(statusPostModerate)
        );
        assumeThat("у группы правильный статус",
                api.userSteps.adGroupsSteps().getGroupStatus(adGroupId),
                equalTo(status)
        );
        api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Test
    public void addAutotargetingToAdGroupTest() {
        GetResponse getResponse = api.userSteps.adGroupsSteps().adGroupsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap().withIds(adGroupId)
                ).withFieldNames(AdGroupFieldEnum.ID, AdGroupFieldEnum.STATUS)
        );
        assertThat("получили правильное значение Status",
                getResponse.getAdGroups(),
                beanDifferV5(
                        Arrays.asList(
                                new AdGroupGetItemMap().withId(adGroupId).withStatus(expectedStatus).getBean()
                        )
                )
        );
    }
}
