package ru.yandex.autotests.directapi.keywords.add;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 27.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Негативные сценарии добавления автотаргетинга")
public class AddAutotargetingNegativeTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void prepareAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void addTwoAutotargetingsInOneRequestTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(
                    new KeywordAddMap().shortAutotargeting(adGroupId),
                    new KeywordAddMap().shortAutotargeting(adGroupId)
                ),
                ExpectedResult.errors(new Notification(7000, Api5ErrorDetails.ONLY_ONE_AUTOTARGETING_IN_ADGROUP)),
                ExpectedResult.errors(new Notification(7000, Api5ErrorDetails.ONLY_ONE_AUTOTARGETING_IN_ADGROUP))
        );
    }
}
