package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 14.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка создания автотаргетинга с разными значениями приоритета для автостратегии")
@Issue("https://st.yandex-team.ru/DIRECT-64386")
@RunWith(Parameterized.class)
public class AddAutotargetingStrategyPriorityTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public PriorityEnum strategyPriority;

    @Parameterized.Parameters(name = "StrategyPriority = {0}")
    public static Iterable<Object[]> stateValues() {
        return Stream.of(PriorityEnum.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static long campaignId;

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    private Long autotargetingId;

    @Before
    @Step("Подготовка данных для теста")
    public void setAutobudgetPriority() {
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> autotargetingIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .autotargeting(adGroupID)
                        .withStrategyPriority(strategyPriority)
        );
        assumeThat("было создан один автотаргетинг", autotargetingIds, hasSize(1));
        autotargetingId = autotargetingIds.get(0);
    }

    @Test
    public void keywordStateOnTest() {
        List<KeywordGetItem> autotargetings = api.userSteps.keywordsSteps().keywordsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap().withIds(autotargetingId)
                ).withFieldNames(KeywordFieldEnum.ID, KeywordFieldEnum.STRATEGY_PRIORITY)
        );

        assertThat("получили верное значение приоритета",
                autotargetings,
                beanDifferV5(
                        Arrays.asList(
                                new KeywordGetItemMap().withId(autotargetingId).withStrategyPriority(strategyPriority).getBean()
                        )
                )
        );
    }
}
