package ru.yandex.autotests.directapi.keywords.add;


import java.nio.charset.Charset;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 28.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка допустимых значений параметров UserParam1 и UserParam2 для автотаргетинга, негативные сценарии")
public class AddAutotargetingUserParamNegativeTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private KeywordAddMap keywordAddMap;

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordAddMap = new KeywordAddMap().shortAutotargeting(adGroupId);
    }

    @Test
    public void userParam1MoreThanMaxLenAddTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(
                        keywordAddMap.withUserParam1(
                                RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1)
                        )
                ),
                ExpectedResult.errors(
                        new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                StringUtils.capitalize(KeywordAddMap.USER_PARAM_1),
                                255
                        )));
    }

    @Test
    public void userParam2MoreThanMaxLenAddTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(
                        keywordAddMap.withUserParam2(
                                RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1)
                        )
                ),
                ExpectedResult.errors(
                        new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                StringUtils.capitalize(KeywordAddMap.USER_PARAM_2),
                                255
                        )));
    }

    @Test
    public void userParam1WrongEncodingAddTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(
                        keywordAddMap.withUserParam1(
                                new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251"))
                        )
                ),
                ExpectedResult.errors(new Notification(5002,
                        Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_1))));
    }

    @Test
    public void userParam2WrongEncodingAddTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(
                        keywordAddMap.withUserParam2(
                                new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251"))
                        )
                ),
                ExpectedResult.errors(new Notification(5002,
                        Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_2))));
    }
}
