package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.AnyOf.anyOf;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 14.04.17.
 * https://st.yandex-team.ru/DIRECT-64666
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка сохранения ставок при создании автотаргетингов")
@Issue("https://st.yandex-team.ru/DIRECT-64386")
public class AddAutotargetingWithBidAndContextBidTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static final Long MIN_BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();
    private static final Long BID1 = MIN_BID * 2L;
    private static final Long BID2 = BID1 * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private static Long adGroupId;

    @BeforeClass
    public static void createAdGroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void addUnitToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    @Description("Добавить один автотаргетинг")
    public void addOneAutotargeting() {
        List<Long> autotargetingIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .autotargeting(adGroupId)
                        .withBid(BID1)
                        .withContextBid(BID2)
        );
        assumeThat("было создан один автотаргетинг", autotargetingIds, hasSize(1));
        Long autotargetingId = autotargetingIds.get(0);

        GetResponse response = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(autotargetingId)
                )
                .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID)
        );

        assertThat("ставки сохранились верно",
                response.getBids(),
                anyOf(beanDifferV5( //perl
                        Collections.singletonList(
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID1).withContextBid(BID2)
                                        .getBean()
                        )
                ),beanDifferV5( //java
                        Collections.singletonList(
                                new BidsGetItemMap().withKeywordId(autotargetingId).withBid(BID1).withContextBid(MIN_BID)
                                        .getBean()
                        )
                ))
        );
    }

    @Test
    @Description("Добавить два автотаргетинга")
    public void addTwoAutotargetings() {
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        List<Long> autotargetingIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .autotargeting(adGroupId)
                        .withBid(BID1)
                        .withContextBid(BID2),
                new KeywordAddMap()
                        .autotargeting(adGroupId2)
                        .withBid(BID2)
                        .withContextBid(BID1)
        );
        assumeThat("было создано два автотаргетинга", autotargetingIds, hasSize(2));
        Long autotargetingId1 = autotargetingIds.get(0);
        Long autotargetingId2 = autotargetingIds.get(1);

        GetResponse response = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new BidsSelectionCriteriaMap()
                                .withKeywordIds(autotargetingId1, autotargetingId2)
                        ).withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID)

        );
        assertThat("ставки сохранилась верно",
                response.getBids(),
                anyOf(beanDifferV5( //perl
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(autotargetingId1).withBid(BID1).withContextBid(BID2).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId2).withBid(BID2).withContextBid(BID1).getBean()
                        )
                ), beanDifferV5( //java
                        Arrays.asList(
                                new BidsGetItemMap().withKeywordId(autotargetingId1).withBid(BID1).withContextBid(MIN_BID).getBean(),
                                new BidsGetItemMap().withKeywordId(autotargetingId2).withBid(BID2).withContextBid(MIN_BID).getBean()
                        )
                ))
        );
    }
}
