package ru.yandex.autotests.directapi.keywords.add;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 02.03.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Проверка недопустимых значений параметра AdGroupId")
public class AddKeywordsAdGroupIdNegativeTest {
    private static LogSteps log = LogSteps.getLogger(AddKeywordsAdGroupIdNegativeTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static final String anotherClient = KeywordsLogins.SINGLE_CLIENT;

    private static long deletedGroupID;
    private static long nonOwnedGroupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long anotherCampaignID = api.as(anotherClient).userSteps.campaignSteps().addDefaultTextCampaign(anotherClient);
        nonOwnedGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignID);

        Long campaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        deletedGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adGroupsSteps().deleteGroup(deletedGroupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3524")
    public void nonExistingAdGroupTest() {
        long nonExistingAdGroup = 123456789l;
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(nonExistingAdGroup)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3525")
    public void deletedAdGroupTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(deletedGroupID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3526")
    public void nonOwnedAdGroupTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(nonOwnedGroupID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }
}
