package ru.yandex.autotests.directapi.keywords.add;


import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Добавление ключевых слов группе, находящейся в различных статусах")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsAdGroupStatusesTest {
    private static LogSteps log = LogSteps.getLogger(AddKeywordsAdGroupStatusesTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private static Long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3533")
    public void addKeywordToDraftGroupTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3534")
    public void addKeywordToModerationGroupTest() {
        log.info("Выставим параметры группы в статус - Moderation");
        api.userSteps.groupFakeSteps().setStatusModerate(groupID, Status.SENDING);
        api.userSteps.groupFakeSteps().setStatusPostModerate(groupID, Status.NO);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3535")
    public void addKeywordToPreacceptedGroupTest() {
        log.info("Выставим параметры группы в статус - Preaccepted");
        api.userSteps.groupFakeSteps().setStatusModerate(groupID, Status.SENT);
        api.userSteps.groupFakeSteps().setStatusPostModerate(groupID, Status.YES);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3536")
    public void addKeywordToAcceptedGroupTest() {
        log.info("Выставим параметры группы в статус - Accepted");
        api.userSteps.groupFakeSteps().setStatusModerate(groupID, Status.YES);
        api.userSteps.groupFakeSteps().setStatusPostModerate(groupID, Status.YES);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3537")
    public void addKeywordToRejectedGroupTest() {
        log.info("Выставим параметры группы в статус - Rejected");
        api.userSteps.groupFakeSteps().setStatusModerate(groupID, Status.NO);
        api.userSteps.groupFakeSteps().setStatusPostModerate(groupID, Status.YES);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                ExpectedResult.success());
    }
}
