package ru.yandex.autotests.directapi.keywords.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 27.10.15.
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка возвращения двух предупреждений в ответе в ситуации," +
        " когда нельзя установить вручную Bid и ContextBid")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
public class AddKeywordsBidAndContextBidTwoWarningsTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT;
    private static final Currency CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap().defaultAverageCpc(CURRENCY))
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3539")
    public void createKeywordWithMinimumContextBid() {
        api.userSteps.keywordsSteps().shouldGetResultOn(Action.ADD, new AddRequestMap().withKeywords(new KeywordAddMap()
                        .defaultKeyword()
                        .withAdGroupId(adGroupId)
                        .withBid(500_000_000L)
                        .withContextBid(550_000_000L)),
                ExpectedResult.warnings(
                        new Notification(10160,
                                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                capitalize(KeywordAddMap.BID)),
                        new Notification(10160,
                                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_CONTEXT,
                                capitalize(KeywordAddMap.CONTEXT_BID))));
    }
}
