package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.ObjectFactory;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 16.10.15.
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка выставления ставок значений ставок по умолчанию при создании ключевого слова")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
@RunWith(Parameterized.class)
public class AddKeywordsBidContextBidDefaultValuesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ObjectFactory objectFactory = new ObjectFactory();

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "Currency = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Currency.RUB, Logins.LOGIN_FOR_RUB},
                {Currency.UAH, Logins.LOGIN_FOR_UAH},
                {Currency.KZT, Logins.LOGIN_FOR_KZT},
                {Currency.EUR, Logins.LOGIN_FOR_EUR},
                {Currency.USD, Logins.LOGIN_FOR_USD},
                {Currency.CHF, Logins.LOGIN_FOR_CHF},
                {Currency.TRY, Logins.LOGIN_FOR_TRY},
                {Currency.BYN, Logins.CLIENT_BYN}
        });
    }

    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3540")
    public void createKeywordDefaultBid() {
        long defaultBid = MoneyCurrency.get(currency).getLongMinPrice().longValue();

        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(adGroupId)
                .withBid(null)
                .withContextBid(null));
        assumeThat("было создано одно ключевое слово", keywordIds, hasSize(1));
        long keywordId = keywordIds.get(0);

        GetResponse response = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withKeywordIds(keywordId)));

        assertThat("ставки по умолчанию установились верно", response.getBids(), beanEquivalentV5(Arrays.asList(
                new BidsGetItemMap()
                        .withBid(defaultBid)
                        .withContextBid(defaultBid).getBean())));
    }
}
