package ru.yandex.autotests.directapi.keywords.add;


import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Тесты на проверку округления ставок")
public class AddKeywordsBidRoundingTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static long adGroupId;

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void bidRoundUpTest() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .shortKeyword()
                .withBid(143845000L)
                .withAdGroupId(adGroupId));

        assumeThat("Добавлено ключевое слово", keywordIds, hasSize(1));

        Long keywordId = keywordIds.get(0);

        List<KeywordGetItem> response = api.userSteps.keywordsSteps().keywordsGet(CLIENT,
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap().withIds(keywordId))
                        .withFieldNames(KeywordFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        KeywordGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getBid(), is(143850000L));
    }

    @Test
    public void contextBidRoundUpTest() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .shortKeyword()
                .withContextBid(143845000L)
                .withAdGroupId(adGroupId));

        assumeThat("Добавлено ключевое слово", keywordIds, hasSize(1));

        Long keywordId = keywordIds.get(0);

        List<KeywordGetItem> response = api.userSteps.keywordsSteps().keywordsGet(CLIENT,
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap().withIds(keywordId))
                        .withFieldNames(KeywordFieldEnum.CONTEXT_BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        KeywordGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getContextBid(), is(143850000L));
    }

    @Test
    public void bidRoundDownTest() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .shortKeyword()
                .withBid(143844999L)
                .withAdGroupId(adGroupId));

        assumeThat("Добавлено ключевое слово", keywordIds, hasSize(1));

        Long keywordId = keywordIds.get(0);

        List<KeywordGetItem> response = api.userSteps.keywordsSteps().keywordsGet(CLIENT,
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap().withIds(keywordId))
                        .withFieldNames(KeywordFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        KeywordGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getBid(), is(143840000L));
    }

    @Test
    public void contextBidRoundDownTest() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .shortKeyword()
                .withContextBid(143844999L)
                .withAdGroupId(adGroupId));

        assumeThat("Добавлено ключевое слово", keywordIds, hasSize(1));

        Long keywordId = keywordIds.get(0);

        List<KeywordGetItem> response = api.userSteps.keywordsSteps().keywordsGet(CLIENT,
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap().withIds(keywordId))
                        .withFieldNames(KeywordFieldEnum.CONTEXT_BID));

        assumeThat("Должен вернуться один элемент", response, hasSize(1));

        KeywordGetItem responseItem = response.get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getContextBid(), is(143840000L));
    }
}
