package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warnings;

/**
 * Created by semkagtn on 16.10.15.
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка выставления ставок (ContextBid) на ключевые слова" +
        " при их создании при разных стратегиях на кампании")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
@RunWith(Parameterized.class)
public class AddKeywordsContextBidDifferentStrategiesTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static final Currency CURRENCY = Currency.RUB;

    private static final long CONTEXT_BID = 200_000_000L;
    private static final long GOAL_ID = MetrikaGoals.getGoalForLogin(LOGIN);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameter(0)
    public TextCampaignSearchStrategyTypeEnum searchStrategyEnum;

    @Parameter(1)
    public TextCampaignNetworkStrategyTypeEnum networkStrategyEnum;

    @Parameter(2)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameter(3)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameter(4)
    public ExpectedResult expectedResult;

    @Parameters(name = "SearchStrategy = {0}, NetworkStrategy = {1}")
    public static Iterable<Object[]> data() {
        ExpectedResult warning = warnings(new Notification(10160,
                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_SET_STRATEGY_IN_WHICH_NETWORK_DEPENDS_ON_SEARCH,
                capitalize(KeywordAddMap.CONTEXT_BID)));
        ExpectedResult autoStrategyWarning = warnings(new Notification(10160,
                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                capitalize(KeywordAddMap.CONTEXT_BID)));

        return Arrays.asList(new Object[][]{

                {TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT,
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(CURRENCY, GOAL_ID),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        warning},

                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE,
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        success()},

                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE,
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        success()},

                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE,
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        success()},

                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF,
                        TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA,
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(CURRENCY),
                        autoStrategyWarning},
        });
    }

    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().addCampMetrikaGoals(campaignId, GOAL_ID, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))));

        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3543")
    public void createKeywordWithBid() {
        api.userSteps.keywordsSteps().shouldGetResultOn(Action.ADD, new ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap()
                        .withKeywords(new KeywordAddMap()
                                .defaultKeyword()
                                .withAdGroupId(adGroupId)
                                .withContextBid(CONTEXT_BID)),
                expectedResult);
    }
}
