package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 04.03.14.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Stories(ApiStories.JSON5)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@Description("Проверка валидации типов полей структуры Keyword")
public class AddKeywordsFieldTypesNegativeTest {
    private static final String singleClient = KeywordsLogins.SINGLE_CLIENT_ADD;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static LogSteps log = LogSteps.getLogger(AddKeywordsFieldTypesNegativeTest.class);
    private static long groupID;
    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public Object fieldValue;

    @Parameterized.Parameter(value = 3)
    public Api5Error api5Error;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> fields() {
        Object[][] data = new Object[][]{
                {"Вещественное число в поле AdGroupId", KeywordAddMap.ADGROUP_ID, 2.13f,
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                path(AddRequestMap.KEYWORDS, KeywordAddMap.ADGROUP_ID))},
                {"JSON объект в поле AdGroupId", KeywordAddMap.ADGROUP_ID, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                path(AddRequestMap.KEYWORDS, KeywordAddMap.ADGROUP_ID))},
                {"Массив в поле AdGroupId", KeywordAddMap.ADGROUP_ID, Arrays.asList(123456),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(AddRequestMap.KEYWORDS, KeywordAddMap.ADGROUP_ID))},
                {"JSON объект в поле UserParam1", KeywordAddMap.USER_PARAM_1, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                                path(AddRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_1))},
                {"Массив в поле UserParam1", KeywordAddMap.USER_PARAM_1, Arrays.asList("Россия"),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                path(AddRequestMap.KEYWORDS, KeywordAddMap.USER_PARAM_1))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3544")
    public void invalidRequiredFieldTypeTest() {
        JSONObject keyword = getShortKeyword();
        keyword.put(StringUtils.capitalize(KeywordAddMap.ADGROUP_ID), groupID);
        keyword.put(StringUtils.capitalize(fieldName), fieldValue);

        JSONObject request = new JSONObject();
        request.put("Keywords", Arrays.asList(keyword));

        api.userSteps.keywordsSteps().shouldGetKeywordErrorJsonOn(
                Action.ADD,
                request,
                api5Error
        );
    }

    private JSONObject getShortKeyword() {
        JSONObject keyword = new JSONObject();
        keyword.put(StringUtils.capitalize(KeywordAddMap.KEYWORD), "котята шредингера купить");
        keyword.put(StringUtils.capitalize(KeywordAddMap.USER_PARAM_1), "qwerty");
        keyword.put(StringUtils.capitalize(KeywordAddMap.USER_PARAM_2), "asdf");
        return keyword;
    }
}
