package ru.yandex.autotests.directapi.keywords.add;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

@ParametersAreNonnullByDefault
public class AddKeywordsJsonTest {
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private Long adGroupId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void createAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void nullInKeywordsListTest() {
        HashMap<String, Object> normalKeyword = new HashMap<>();
        normalKeyword.put("Keyword", "Светильники дёшево");
        normalKeyword.put("AdGroupId", adGroupId);
        List<HashMap> keywords = asList(
                normalKeyword,
                null);

        Map<String, Object> request = new HashMap<>();
        request.put("Keywords", keywords);

        api.userSteps.keywordsSteps().shouldGetJSONErrorOn(ServiceNames.KEYWORDS,
                client,
                Action.ADD,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ARRAY_CONTAINS_NULL,
                        path(AddRequestMap.KEYWORDS)));
    }
}
