package ru.yandex.autotests.directapi.keywords.add;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка на отсутствие переминусовки ключевых фраз")
@Issue("https://st.yandex-team.ru/DIRECT-41661")
public class AddKeywordsMinusUnglueTest {
    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_UPDATE;

    private static final String EXISTED_KEYWORD = "слово1";
    private static final String KEYWORD2 = "слово2";
    private static final String KEYWORD3 = "слово1 слово2";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long adGroupId;
    private Long existedKeywordId1;

    @Before
    public void before() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(EXISTED_KEYWORD)
        );
        existedKeywordId1 = keywordIds.get(0);
    }

    @Test
    public void keywordsAfterAddingMustBeWithoutExtraMinusWords() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD2),
                new KeywordAddMap()
                        .withAdGroupId(adGroupId)
                        .withKeyword(KEYWORD3)
        );
        Long keywordId2 = keywordIds.get(0);
        Long keywordId3 = keywordIds.get(1);
        List<KeywordGetItem> items =
                api.userSteps.keywordsSteps().keywordsGetById(existedKeywordId1, keywordId2, keywordId3);
        List<String> keywords = items.stream().map(KeywordGetItem::getKeyword).collect(Collectors.toList());
        assertThat("Ключевые фразы соотвествуют ожиданиям",
                keywords, contains(EXISTED_KEYWORD, KEYWORD2, KEYWORD3));
    }
}
