package ru.yandex.autotests.directapi.keywords.add;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 11.02.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Позитивные сценарии добавления ключевых слов")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsPositiveTest {

    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private Long adGroupId;
    private Long bannerId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);

    }

    @Before
    public void createAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3559")
    public void addOnlyRequiredFieldsTest() {
        List<Long> keywordIDs = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(adGroupId));

        assertThat("добавлено ключевое слово", keywordIDs, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3560")
    public void addAllKeywordFieldsTest() {
        //https://st.yandex-team.ru/DIRECT-39058
        List<Long> keywordIDs = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(adGroupId));
        assertThat("добавлено ключевое слово", keywordIDs, hasSize(1));
    }

    @Test
    public void addKeywordToArchivedGroupTest() {
        api.userSteps.adsSteps().adsArchive(bannerId);

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(adGroupId)),
                ExpectedResult.success());
    }
}
