package ru.yandex.autotests.directapi.keywords.add;

import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-5469
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Запросы на добавление ключевых слов по протоколу SOAP")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsSoapTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @Description("Запрос на добавление ключевых слов без поля Keywords")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3562")
    public void requestWithoutKeywordsField() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withKeywords(null),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(AddRequestMap.KEYWORDS)));
    }

    @Test
    @Description("Запрос на добавление без поля Keywords.Keyword")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3563")
    public void requestWithoutKeywordField() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withKeywords(new KeywordAddMap()
                                .withAdGroupId(0l)
                                .withKeyword(null)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(AddRequestMap.KEYWORDS),
                        StringUtils.capitalize(KeywordAddMap.KEYWORD)));
    }

    @Test
    @Description("Валидный запрос на добавление ключевого слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3564")
    public void requestWithoutAdGroupIdField() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withKeywords(new KeywordAddMap()
                                .defaultKeyword()
                                .withAdGroupId(adGroupID)),
                ExpectedResult.success());
    }
}
