package ru.yandex.autotests.directapi.keywords.add;

import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Тесты на добавление стоп-слов")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsStopwordsTest {
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private Long adGroupId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void createAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void addKeywordWithStopwordTest() {
        String expected = "купить +ту квартиру";
        List<Long> keywordIDs = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .withKeyword(expected.replaceAll("\\+", ""))
                .withAdGroupId(adGroupId));

        assertThat("добавлено ключевое слово", keywordIDs, hasSize(1));

        List<KeywordGetItem> result = api.userSteps.keywordsSteps().keywordsGet(new GetRequestMap()
                .withSelectionCriteria(new KeywordsSelectionCriteriaMap().withIds(keywordIDs.get(0)))
                .withFieldNames(KeywordFieldEnum.KEYWORD));

        assertThat("Стоп-слово зафиксировано", result.get(0).getKeyword(), equalTo(expected));
    }
}
