package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 27.10.15.
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка возвращения приоритета стратегии методом Keywords.get")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
@RunWith(Parameterized.class)
public class AddKeywordsStrategyPriorityTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public PriorityEnum expectedPriority;

    @Parameterized.Parameters(name = "StrategyPriority = {0}")
    public static Iterable<Object[]> stateValues() {
        return Stream.of(PriorityEnum.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static long adGroupID;

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    private long keywordID;

    @Before
    @Step("Подготовка данных для теста")
    public void setAutobudgetPriority() {
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(adGroupID)
                .withStrategyPriority(expectedPriority));
        assumeThat("было создано одно ключевое слово", keywordIds, hasSize(1));
        keywordID = keywordIds.get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3644")
    public void keywordStateOnTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new GetRequestMap()
                .withFieldNames(KeywordFieldEnum.ID, KeywordFieldEnum.STRATEGY_PRIORITY)
                .withSelectionCriteria(new KeywordsSelectionCriteriaMap().withIds(keywordID)));

        assertThat("вернулось верное значение приоритета стратегии", keywords,
                beanEquivalentV5(Arrays.asList(
                        new KeywordGetItemMap().withStrategyPriority(expectedPriority).getBean())));
    }
}
