package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 11.02.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка некорректной структуры запроса Add")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsStructureNegativeTest {
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static LogSteps log = LogSteps.getLogger(AddKeywordsStructureNegativeTest.class);
    private static long groupID;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3566")
    public void invalidActionNameTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ACTION_INVALID,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                new Api5Error(55, Api5ErrorDetailsJava.INVALID_METHOD_VALUE));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3567")
    public void emptyActionNameTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ACTION_EMPTY,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .shortKeyword()
                        .withAdGroupId(groupID)),
                new Api5Error(55, Api5ErrorDetailsJava.OPERATION_IS_NOT_SET));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3565")
    public void noKeywordsElementInRequestTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.KEYWORDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3568")
    public void emptyKeywordsPackTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap().withKeywords(null),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(AddRequestMap.KEYWORDS), 1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3569")
    public void noRequiredFieldKeywordTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .withAdGroupId(groupID)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(AddRequestMap.KEYWORDS),
                        StringUtils.capitalize(KeywordAddMap.KEYWORD)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3570")
    public void integerArrayInKeywordsTest() {
        List<Integer> invalid = Arrays.asList(123, 456, 789);
        JSONObject request = new JSONObject();
        request.put("Keywords", invalid);

        JavaOrPerlApi5Error
                .java(
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE,
                                path(AddRequestMap.KEYWORDS))
                )
                .perl(
                        new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
                                path(AddRequestMap.KEYWORDS))
        );
    }
}
