package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 05.11.15.
 * https://st.yandex-team.ru/TESTIRT-7663
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-47543")
@Description("Добавить ключевые слова в группы разных типов")
@RunWith(Parameterized.class)
public class AddKeywordsToAdGroupsOfDifferentTypesTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "adgroup type = {1}")
    public static Iterable<Object[]> data() {
        List<AdGroupType> whiteList =
                Arrays.asList(AdGroupType.BASE, AdGroupType.MOBILE_CONTENT, AdGroupType.CPM_BANNER);

        EnumMap<AdGroupType, CampaignType> groupToCampaignTypes = new EnumMap<>(AdGroupType.class);
        groupToCampaignTypes.put(AdGroupType.BASE, CampaignType.TEXT);
        groupToCampaignTypes.put(AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT);
        groupToCampaignTypes.put(AdGroupType.DYNAMIC, CampaignType.DYNAMIC);
        groupToCampaignTypes.put(AdGroupType.CPM_BANNER, CampaignType.CPM_BANNER);
        // TODO: создание перфоманс кампаний через API5 пока не поддерживается
        //groupToCampaignTypes.put(AdGroupType.PERFORMANCE, CampaignType.PERFORMANCE);

        List<Object[]> parameters = whiteList.stream()
                .map(type -> new Object[]{groupToCampaignTypes.get(type), type, ExpectedResult.success()})
                .collect(Collectors.toList());

        List<Object[]> blackListParameters = Stream.of(AdGroupType.values())
                .filter(type -> !whiteList.contains(type))
                .filter(type -> groupToCampaignTypes.containsKey(type))
                .map(type -> new Object[]{groupToCampaignTypes.get(type), type, ExpectedResult.errors(
                        new Notification(6001, Api5ErrorDetails.FORBIDDEN_TO_CREATE_KEYWORDS_IN_GROUP_OF_THIS_TYPE))})
                .collect(Collectors.toList());

        parameters.addAll(blackListParameters);

        return parameters;
    }

    private long campaignId;
    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createAdgroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        if (campaignType == CampaignType.CPM_BANNER) {
            api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
            adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        } else {
            adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        }
    }

    @Test
    public void addKeywordToAdGroup() {
        api.userSteps.keywordsSteps().shouldGetResultOn(Action.ADD, new AddRequestMap()
                        .withKeywords(new KeywordAddMap()
                                .defaultKeyword()
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }
}
