package ru.yandex.autotests.directapi.keywords.add;


import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 27.02.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка допустимых значений параметров UserParam1 и UserParam2")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddKeywordsUserParamTest {
    private static LogSteps log = LogSteps.getLogger(AddKeywordsUserParamTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;

    private KeywordAddMap keywordMap;
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String fieldValue;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "field = {0}, value = {1}")
    public static Collection fieldsValue() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {KeywordAddMap.USER_PARAM_1, "Пустая строка",
                        "",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Строка из пробелов",
                        "  ",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Латинские символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Цифровые символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Латинские и цифровые символы",
                        RandomStringUtils.randomAlphanumeric(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Кириллические символы",
                        "параметр",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Турецкие символы",
                        "türkçe",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Спецсимволы",
                        "param/param?key=1",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Строка с пробелом",
                        RandomStringUtils.randomAlphabetic(5) + "  " + RandomStringUtils.randomAlphabetic(5),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Минимальная длина",
                        RandomStringUtils.randomAlphabetic(1),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Максимальная длина",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_1, "Длина превышает максимальную",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1),
                        ExpectedResult.errors(
                                new Notification(5001,
                                        Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_1),
                                        255
                                ))},
                {KeywordAddMap.USER_PARAM_1, "Кодировка UTF-8 как CP1251",
                        new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251")),
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                StringUtils.capitalize(KeywordAddMap.USER_PARAM_1)))},

                {KeywordAddMap.USER_PARAM_2, "Пустая строка",
                        "",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Строка из пробелов",
                        "  ",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Латинские символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Цифровые символы",
                        RandomStringUtils.randomAlphabetic(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Латинские и цифровые символы",
                        RandomStringUtils.randomAlphanumeric(10),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Кириллические символы",
                        "параметр",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Турецкие символы",
                        "türkçe",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Спецсимволы",
                        "param/param?key=1",
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Строка с пробелом",
                        RandomStringUtils.randomAlphabetic(5) + "  " + RandomStringUtils.randomAlphabetic(5),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Минимальная длина",
                        RandomStringUtils.randomAlphabetic(1),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Максимальная длина",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH),
                        ExpectedResult.success()},
                {KeywordAddMap.USER_PARAM_2, "Длина превышает максимальную",
                        RandomStringUtils.randomAlphabetic(KeywordAddMap.MAX_USER_PARAM_LENGTH + 1),
                        ExpectedResult.errors(
                                new Notification(5001,
                                        Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        StringUtils.capitalize(KeywordAddMap.USER_PARAM_2),
                                        255
                                ))},
                {KeywordAddMap.USER_PARAM_2, "Кодировка UTF-8 как CP1251",
                        new String("Параметр".getBytes(Charset.forName("UTF-8")), Charset.forName("cp1251")),
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                StringUtils.capitalize(KeywordAddMap.USER_PARAM_2)))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordMap = new KeywordAddMap().shortKeyword().withAdGroupId(groupID);
        ReflectionUtils.setBeanMapFieldValue(keywordMap, "with" + StringUtils.capitalize(fieldName), fieldValue);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3580")
    public void userParamAddTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(keywordMap),
                expectedResult
        );
    }
}
