package ru.yandex.autotests.directapi.keywords.add;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.ObjectFactory;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 16.10.15.
 * https://st.yandex-team.ru/TESTIRT-7489
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка выставления ставок для ключевых слов при создании ключевых слов")
@Issue("https://st.yandex-team.ru/DIRECT-45319")
public class AddKeywordsWithBidAndContextBidTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static ObjectFactory objectFactory = new ObjectFactory();

    private static long adGroupId;

    @BeforeClass
    public static void createAdGroup() {
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
    }

    @Before
    public void addUnitToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Добавить одно ключевое слово")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3581")
    public void addOneKeyword() {
        long bid = 211_000_000L;
        long contextBid = 333_000_000L;

        List<Long> keywords = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withBid(bid)
                .withContextBid(contextBid)
                .withAdGroupId(adGroupId));
        assumeThat("было создано одно ключевое слово", keywords, hasSize(1));
        long keywordId = keywords.get(0);

        GetResponse response = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withKeywordIds(keywordId)));

        assertThat("ставка сохранилась верно", response.getBids(), beanEquivalentV5(Arrays.asList(new BidsGetItemMap()
                .withBid(bid)
                .withContextBid(contextBid)
                .getBean())));
    }

    @Test
    @Description("Добавить два ключевых слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3582")
    public void addTwoKeywords() {
        long bid1 = 211_000_000L;
        long contextBid1 = 333_000_000L;

        long bid2 = 315_000_000L;
        long contextBid2 = 276_000_000L;

        List<Long> keywords = api.userSteps.keywordsSteps().keywordsAdd(
                new KeywordAddMap()
                        .defaultKeyword()
                        .withBid(bid1)
                        .withContextBid(contextBid1)
                        .withAdGroupId(adGroupId),
                new KeywordAddMap()
                        .defaultKeyword()
                        .withBid(bid2)
                        .withContextBid(contextBid2)
                        .withAdGroupId(adGroupId));
        assumeThat("было создано два ключевых слова", keywords, hasSize(2));
        long keywordId1 = keywords.get(0);
        long keywordId2 = keywords.get(1);

        GetResponse response = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.KEYWORD_ID, BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withKeywordIds(keywordId1, keywordId2)));
        assumeThat("вернулся массив Bids в ответе", response.getBids(), notNullValue());
        response.getBids().sort((x, y) -> x.getKeywordId().compareTo(y.getKeywordId()));

        assertThat("ставка сохранилась верно", response.getBids(), beanEquivalentV5(Arrays.asList(
                new BidsGetItemMap()
                        .withBid(bid1)
                        .withContextBid(contextBid1)
                        .getBean(),
                new BidsGetItemMap()
                        .withBid(bid2)
                        .withContextBid(contextBid2)
                        .getBean())));
    }
}
