package ru.yandex.autotests.directapi.keywords.add;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка того, что ворнинги апи не затирают ошибки ядровой валидации")
@Issue("https://st.yandex-team.ru/DIRECT-94421")
public class AddLongKeywordsWithApiWarningsTest {


    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static long adGroupID;
    private static PriorityEnum expectedPriority;

    @BeforeClass
    public static void setUp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithSearchStrategy(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(), LOGIN);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        expectedPriority = PriorityEnum.NORMAL;
    }

    @Test
    public void longKeyword_StrategyPriorityUnusedForManualStrategy_Test() {
        String goodKeyword = "магазин слон окно";
        String badKeyword = "магазин слон хомяк антилопа гиена краб тюлень окно";
        AddRequestMap addRequestMap = new AddRequestMap().withKeywords(
                new KeywordAddMap()
                        .withKeyword(goodKeyword)
                        .withAdGroupId(adGroupID)
                        .withStrategyPriority(expectedPriority),
                new KeywordAddMap()
                        .withKeyword(badKeyword)
                        .withAdGroupId(adGroupID)
                        .withStrategyPriority(expectedPriority));
        Notification warning = new Notification(10161,
                Api5ErrorDetailsJava.STRATEGY_PRORITY_NOT_USED_FOR_MANUAL_STRATEGY,
                path(KeywordAddMap.STRATEGY_PRIORITY));
        Notification error = new Notification(5140, Api5ErrorDetails.KEYWORD_COULD_NOT_CONTAIN_MORE_WORDS, badKeyword);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                addRequestMap,
                ExpectedResult.warnings(warning),
                ExpectedResult.create(nullValue(), singletonList(warning), singletonList(error)));
    }
}
