package ru.yandex.autotests.directapi.keywords.add.keyword;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.03.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Добавление ключевых слов со сложными сочетаниями скобок [] - фиксации порядка слов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddKeywordsComplicatedBracketsTest {
    private static LogSteps log = LogSteps.getLogger(AddKeywordsComplicatedBracketsTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static Long campaignID;

    private long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String keywordValue;


    @Parameterized.Parameter(value = 1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"[билет в питер]", ExpectedResult.success()},
                {"[питер]", ExpectedResult.success()},
                {"[!питер]", ExpectedResult.success()},
                {"\"[билет в питер]\"", ExpectedResult.success()},
                {"купить [билет в питер]", ExpectedResult.success()},
                {"\"купить [билет в питер]\"", ExpectedResult.success()},
                {"купить [билет в питер] -авиабилет ", ExpectedResult.success()},
                {"купить [билет в !питер]", ExpectedResult.success()},

                {"[билет в питер][купить дешево]",
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED,
                                "[билет в питер][купить дешево]"))},
                {"[билет в питер [купить] дешево]",
                        ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED,
                                "[билет в питер [купить] дешево]"))},

                {"[билет на самолет] !питер -купить", ExpectedResult.success()},
                {"купить [билет в !питере] +на спектакль", ExpectedResult.success()},

                {"[(купить|продать) (авто|мото)]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS,
                                "[(купить|продать) (авто|мото)]"))},
                {"[билет +в питер]",
                        ExpectedResult.errors(
                                new Notification(5002, Api5ErrorDetailsJava.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS,
                                        "[билет +в питер]"))},
                //DIRECT-41433
                /*
                {"[\"купить билет\"]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS, "[\"купить билет\"]"))},
                {"[купить билет -питер]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS, "[купить билет -питер]"))},
                {"билет ![купить дешево]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_COMBINATION_OF_CHARACTERS, "билет ![купить дешево]"))},
                {"\"в питер\" [купить билет]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES, "\"в питер\" [купить билет]"))},
                {"купить [\"билет в питер\"]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.KEYWORD_INCORRECT_USAGE_OF_QUOTES, "купить [\"билет в питер\"]"))},
                {"[[]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[]"))},
                {"[]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[]"))},
                {"[[[]]]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[[]]]"))},
                {"купить билеты []",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "купить билеты []"))},
                {"[[билет в питер]",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED, "[[билет в питер]"))}
*/
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовим группу")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3585")
    public void keywordBracketsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .withAdGroupId(groupID)
                        .withKeyword(keywordValue)),
                expectedResult);
    }

    /*
    @Test
    public void keywordBracketsTestOld() {
        api.userSteps.bannerSteps().createBanner(new BannerInfoMap(api.type())
                .defaultBanner()
                .withCampaignID(campaignID)
                .withPhrases(new BannerPhraseInfoMap(api.type())
                        .withTextPhrase(keywordValue)
                        .withPrice(0.01f)));
    }
    */
}
