package ru.yandex.autotests.directapi.keywords.add.keyword;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 27.01.2016
 * https://st.yandex-team.ru/TESTIRT-8345
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Issue("* https://st.yandex-team.ru/DIRECT-50300")
@Description("Проверка добавления уже существующего Keyword")
public class AddKeywordsExistingKeywordTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static final String KEYWORD_INITIAL = "на лабутенах";
    private static final String KEYWORD_NEW = "на лабутене";
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private long keywordId;
    private long groupID;
    private KeywordGetItem keywordInitial;

    @BeforeClass
    public static void createCampaign(){
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Before
    public void prepareGroup(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordId = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .withAdGroupId(groupID)
                .withBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue())
                .withKeyword(KEYWORD_INITIAL)
        ).get(0);

        keywordInitial = api.userSteps.keywordsSteps().keywordsGetByAdGroupId(groupID).stream()
                .filter(keywordGetItem -> keywordGetItem.getId() == keywordId).findFirst().get();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3587")
    public void keywordsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .withAdGroupId(groupID)
                        .withBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2)
                        .withKeyword(KEYWORD_NEW)),
                ExpectedResult.warnings(keywordId, new Notification(10140)));
        KeywordGetItem keyword = api.userSteps.keywordsSteps().keywordsGetByAdGroupId(groupID).stream()
                .filter(keywordGetItem -> keywordGetItem.getId() == keywordId).findFirst().get();
        assertThat("Ключевая фраза не ищменилась", keyword, beanDiffer(keywordInitial));
    }

}
