package ru.yandex.autotests.directapi.keywords.add.keyword;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.03.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Добавление ключевых слов с минус-словами")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddKeywordsMinusWordTest {
    private static LogSteps log = LogSteps.getLogger(AddKeywordsMinusWordTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_ADD;
    private static Long campaignID;

    private long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String keywordValue;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                // TODO
                {"Ключевое с минус-словом", "остекление -балкон",
                        ExpectedResult.success()},
                {"Ключевое с минусом из стоп-слова", "мультики -все",
                        ExpectedResult.success()},
                {"Ключевое с минусом из стоп-слова с символом 'ё'", "хаски -всё",
                        ExpectedResult.success()},
                {"Ключевое с несколькими минус-словами", "остекление -балкон -окно -витраж",
                        ExpectedResult.success()},
                {"Ключевое с одинаковыми минус-словами", "ремонт -бесплатный -бесплатный",
                        ExpectedResult.success()},
                {"Ключевые слова с минус-словом", "остекление лоджий -срочное",
                        ExpectedResult.success()},
                {"Минус-слово с фиксацией словоформы", "остекление -!балконов",
                        ExpectedResult.success()},
                {"Минус-слово исключающее ключевое", "балкон -балкон",
                        ExpectedResult.errors(new Notification(5161, Api5ErrorDetails.KEYWORD_COULD_NOT_BE_USED_AS_MINUS_WORD, "балкон", "балкон -балкон"))},
                {"Ключевое слово предваряется минус-словом", "высокий -полет квадрокоптер",
                        ExpectedResult.errors(new Notification(5161, Api5ErrorDetails.ONLY_SEPARATE_WORDS_COULD_BE_EXCLUDED, "высокий -полет квадрокоптер"))},
                {"Минус-слово без ключевого", "-балкон",
                        ExpectedResult.errors(new Notification(5161, Api5ErrorDetails.KEYWORD_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY, "-балкон"))},
                //DIRECT-41516
                /*
                {"Некорректное использование символа '-'", "балкон - остекление",
                        ExpectedResult.errors(new Notification(1000103, Api5ErrorDetails.INCORRECT_USE_OF_SYMBOL_IN_KEYWORD, "-", "балкон - остекление"))},
                */
                {"Простая группировка с минус-словами", "сервисное обслуживание (Kia | Ford) -гарантийное -бесплатное",
                        ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.INVALID_KEYWORD_SYMBOLS,
                                "сервисное обслуживание (Kia | Ford) -гарантийное -бесплатное"))},
                {"Ключевое с минус-словом на белорусском языке", "аплата -наяўнымі",
                        ExpectedResult.success()}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign(){
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовим группу")
    public void prepareGroup(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3588")
    public void keywordMinusWordsTest() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withKeywords(new KeywordAddMap()
                        .withAdGroupId(groupID)
                        .withKeyword(keywordValue)),
                expectedResult);
    }
}
