package ru.yandex.autotests.directapi.keywords.add.limit;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 22.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.ADD)
@Description("Проверка предельного количества допустимых ключевых слов в одном запросе")
@Tag(TagDictionary.TRUNK)
public class AddKeywordsRequestLimitTest {
    private static final String client = KeywordsLogins.SINGLE_CLIENT;
    private static final int KEYWORDS_IN_REQUEST_LIMIT = 1000;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Максимальное колличество ключевых слов в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3590")
    public void maxKeywordsInOneRequestTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.ADD,
                new AddRequestMap().withKeywords(getKeywordsMap(123456)),
                new Api5Error(9300, Api5ErrorDetails.KEYWORD_IN_REQUEST_LIMIT)
        );
    }

    private KeywordAddMap[] getKeywordsMap(long groupID){
        KeywordAddMap[] keywords = new KeywordAddMap[KEYWORDS_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < KEYWORDS_IN_REQUEST_LIMIT + 1; i++) {
            keywords[i] = new KeywordAddMap()
                    .withKeyword(RandomStringUtils.randomAlphabetic(17))
                    .withAdGroupId(groupID);
        }
        return keywords;
    }
}
