package ru.yandex.autotests.directapi.keywords.delete;

import java.util.Arrays;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 2/27/15.
 * https://st.yandex-team.ru/TESTIRT-4389
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-36384")
@Description("Удаление максимального числа ключевых слов за один запрос")
public class DeleteIdsLengthRestrictionTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Удалить " + IdsCriteriaMap.IDS_MAX_LENGTH + " ключевых слов за один запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3592")
    public void deleteMaxKeywordsWithOneRequest() {
        Long[] keywordIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH]);
        for (int i = 0; i < keywordIDs.length; i++) {
            keywordIDs[i] = (long) (i + 1);
        }

        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.IDS_MAX_LENGTH];
        Arrays.fill(expectedResults, ExpectedResult.errors(
                new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)));

        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordIDs)),
                expectedResults);
    }
}
