package ru.yandex.autotests.directapi.keywords.delete;

import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(KeywordsFeatures.DELETE)
@Description("Позитивные сценарии удаления ключевых фраз")
@Tag(TagDictionary.TRUNK)
public class DeleteKeywordPositiveTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long bannerId;
    private Long keywordId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        List<Long> keywordIds = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupId, 1);

        assumeThat("Ключевая фраза должна быть создана", keywordIds, hasSize(1));

        keywordId = keywordIds.get(0);
    }

    @Test
    public void deleteKeywordInArchivedAdGroupTest() {
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId);
        api.userSteps.adsSteps().adsArchive(bannerId);

        api.userSteps.keywordsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(keywordId)),
                ExpectedResult.success(keywordId));
    }
}
