package ru.yandex.autotests.directapi.keywords.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 24.03.15.
 * https://st.yandex-team.ru/TESTIRT-4101
 */
@Aqua.Test
@Features(KeywordsFeatures.DELETE)
@Issue("https://st.yandex-team.ru/DIRECT-36384")
@Description("Удалить ключевые слова субклиента от имени агенства, созданные другим агенством")
public class DeleteKeywordsWithAgencyLoginCreatedByAgencyTest {

    private static final String AGENCY_WITH_SUBCLIENTS = KeywordsLogins.AGENCY_3;
    private static final String FIRST_SUBCLIENT = KeywordsLogins.SUBCLIENT_1;
    private static final String SECOND_SUBCLIENT = KeywordsLogins.SUBCLIENT_3;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static long keywordID1;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createSitelinksSet() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_WITH_SUBCLIENTS);

        api.as(AGENCY_WITH_SUBCLIENTS);
        Long campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign(FIRST_SUBCLIENT);
        long adGroupID2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID2, FIRST_SUBCLIENT);
        keywordID1 = api.userSteps.keywordsSteps().addDefaultKeyword(FIRST_SUBCLIENT, adGroupID2);
    }

    @Test
    @Description("Удалить ключевые слова субклиента от имени агенства для другого субклиента")
    @Title("DIRECT-48813")
    public void deleteKeywordsSetWithAgencyLoginCreatedForAnotherSubclient() {
        api.as(AGENCY_WITH_SUBCLIENTS);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.DELETE,
                SECOND_SUBCLIENT,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID1)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)));
    }
}
