package ru.yandex.autotests.directapi.keywords.delete;

import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by semkagtn on 2/19/15.
 * https://st.yandex-team.ru/TESTIRT-4389
 */
@Aqua.Test
@Features(KeywordsFeatures.DELETE)
@Issue("https://st.yandex-team.ru/DIRECT-36384")
@Description("Проверка удаления ключевых слов, когда в запросе присутствуют валидный и невалидный объекты")
@Tag(TagDictionary.TRUNK)
public class DeleteMultipleErrorTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignID;
    private static long adGroupID;

    private long keywordID;
    private long nonexistentKeywordID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        nonexistentKeywordID = keywordID + 100000;
    }

    @Test
    @Description("Вызвать метод удаления ключевых слов для существующего и несуществующего ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3604")
    public void deleteExistentAndNonexistentKeywords() {
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID, nonexistentKeywordID)),
                ExpectedResult.success(keywordID),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.KEYWORD_NOT_FOUND)));
        List<KeywordGetItem> result = api.userSteps.keywordsSteps().keywordsGetByAdGroupId(adGroupID);
        List<Long> actualKeywordIDs = extract(result, on(KeywordGetItem.class).getId());
        assertThat("ключевое слово было удалено", actualKeywordIDs, not(hasItem(keywordID)));
    }
}
