package ru.yandex.autotests.directapi.keywords.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywords.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 12.05.15.
 * https://st.yandex-team.ru/TESTIRT-4389
 */
@Aqua.Test
@Features(KeywordsFeatures.DELETE)
@Issue("https://st.yandex-team.ru/DIRECT-36384")
@Description("Запросы на удаление ключевых слов через протокол SOAP")
public class DeleteSoapTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля SelectionCriteria в запросе на удаление ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3608")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Issue("DIRECT-88268")
    @Description("Запрос без поля SelectionCriteria.Ids в запросе на удаление ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3607")
    public void requestWithoutIds() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Валидный запрос на удаление ключевых слов")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3609")
    public void correctRequest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.keywordsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(keywordID)),
                ExpectedResult.success(keywordID));
    }
}
