package ru.yandex.autotests.directapi.keywords.delete;

import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 12.03.15.
 * https://st.yandex-team.ru/TESTIRT-4389
 */
@Aqua.Test
@Features(KeywordsFeatures.DELETE)
@Issue("https://st.yandex-team.ru/DIRECT-36384")
@Description("Проверки удаления ключевых слов и автотаргетингов")
@Tag(TagDictionary.TRUNK)
public class DeleteTest {

    private static final String LOGIN = KeywordsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId1;
    private static Long adGroupId2;
    private long firstKeywordID;
    private long secondKeywordID;
    private Long autotargetingId1;
    private Long autotargetingId2;

    @BeforeClass
    public static void createAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        Long campaignId2 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId2);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createKeywords() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> keywordIDs = api.userSteps.keywordsSteps().addDefaultKeywords(adGroupId1, 2);
        firstKeywordID = keywordIDs.get(0);
        secondKeywordID = keywordIDs.get(1);
        autotargetingId1 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId1);
        autotargetingId2 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId2);
    }

    @Test
    @Description("Удалить одно ключевое слово")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3610")
    public void deleteOneKeyword() {
        api.userSteps.keywordsSteps().keywordsDelete(firstKeywordID);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withIds(firstKeywordID, secondKeywordID));
        List<Long> keywordIDs = extract(keywords, on(KeywordGetItem.class).getId());
        assertThat("удалилась верная фраза", keywordIDs, contains(secondKeywordID));
    }

    @Test
    @Description("Удалить два ключевых слова")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3611")
    public void deleteTwoKeywords() {
        api.userSteps.keywordsSteps().keywordsDelete(firstKeywordID, secondKeywordID);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(new KeywordsSelectionCriteriaMap()
                .withIds(firstKeywordID, secondKeywordID));
        List<Long> keywordIDs = extract(keywords, on(KeywordGetItem.class).getId());
        assertThat("удалилась верная фраза", keywordIDs, empty());
    }

    @Test
    @Description("Удалить один автотаргетинг")
    public void deleteOneAutotargeting() {
        api.userSteps.keywordsSteps().keywordsDelete(autotargetingId1);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(autotargetingId1, autotargetingId2, firstKeywordID, secondKeywordID);
        List<Long> keywordIDs = extract(keywords, on(KeywordGetItem.class).getId());
        assertThat("удалился правильный автотаргетинг", keywordIDs, containsInAnyOrder(autotargetingId2, firstKeywordID, secondKeywordID));
    }

    @Test
    @Description("Удалить автотаргетинг и фразу")
    public void deleteOneAutotargetingAndOneKeyword() {
        api.userSteps.keywordsSteps().keywordsDelete(autotargetingId2, secondKeywordID);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(autotargetingId1, autotargetingId2, firstKeywordID, secondKeywordID);
        List<Long> keywordIDs = extract(keywords, on(KeywordGetItem.class).getId());
        assertThat("удалились правильные автотаргетинг и фраза", keywordIDs, containsInAnyOrder(autotargetingId1, firstKeywordID));
    }

    @Test
    @Description("Удалить все автотаргетинги и фразы")
    public void deleteAllAutotargetingsAndKeywords() {
        api.userSteps.keywordsSteps().keywordsDelete(autotargetingId1, autotargetingId2, firstKeywordID, secondKeywordID);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(autotargetingId1, autotargetingId2, firstKeywordID, secondKeywordID);
        assertThat("получили пустой ответ", keywords, empty());
    }
}
