package ru.yandex.autotests.directapi.keywords.get;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 31.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка получения автотаргетинга для приостановленной и архивной кампаний")
public class GetAutotargetingForSuspendedAndArchivedCampaignsTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static Long archivedCampaignAutotargetingId;
    protected static Long suspendedCampaignAutotargetingId;

    @BeforeClass
    public static void prepareGroup() {
        Long suspendedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long suspendedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(suspendedCampaignId);
        api.userSteps.adsSteps().addDefaultTextAd(suspendedAdGroupId);
        suspendedCampaignAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(suspendedAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(suspendedCampaignId);
        assumeThat("кампания приостановлена",
                api.userSteps.campaignSteps().getCampaigns(suspendedCampaignId).get(0).getState(),
                equalTo(CampaignStateGetEnum.SUSPENDED)
        );

        Long archivedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long archivedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archivedCampaignId);
        api.userSteps.adsSteps().addDefaultTextAd(archivedAdGroupId);
        archivedCampaignAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(archivedAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(archivedCampaignId);
        assumeThat("кампания заархивирована",
                api.userSteps.campaignSteps().getCampaigns(archivedCampaignId).get(0).getState(),
                equalTo(CampaignStateGetEnum.ARCHIVED)
        );
    }

    @Test
    public void getAutotargetingFromSuspendedCampaignTest() {
        List<KeywordGetItem> autotargetingGetItems = api.userSteps.keywordsSteps().keywordsGetById(suspendedCampaignAutotargetingId);
        assertThat("получили автотаргетинг из приостановленной кампании",
                autotargetingGetItems.size(),
                equalTo(1)
        );
    }

    @Test
    public void getAutotargetingFromArchivedCampaignTest() {
        List<KeywordGetItem> autotargetingGetItems = api.userSteps.keywordsSteps().keywordsGetById(archivedCampaignAutotargetingId);
        assertThat("получили автотаргетинг из архивной кампании",
                autotargetingGetItems,
                empty()
        );
    }
}
