package ru.yandex.autotests.directapi.keywords.get;

import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 30.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка значений полей, недоступных у автотаргетинга")
public class GetAutotargetingInaccessibleNillableFieldsTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_GET;

    private static KeywordGetItem autotargetingGetItem;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareGroup() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetByIdWithFields(
                Collections.singletonList(
                        KeywordFieldEnum.PRODUCTIVITY
                ),
                autotargetingId
        );
        assumeThat("получен бесфразный таргетинг", keywords, Matchers.hasSize(1));
        autotargetingGetItem = keywords.get(0);
    }

    @Test
    public void productivityTest() {
        assertThat("значение продуктивности nil", autotargetingGetItem.getProductivity().isNil(), equalTo(true));
    }
}
