package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 31.03.2017.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка значений полей StatisticsSearch и StatisticsNetwork у автотаргетинга")
public class GetAutotargetingStatisticsFieldsTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_GET;

    private static KeywordGetItem autotargetingGetItem;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareGroup() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetByIdWithFields(
                Arrays.asList(
                        KeywordFieldEnum.STATISTICS_SEARCH,
                        KeywordFieldEnum.STATISTICS_NETWORK
                ),
                autotargetingId
        );
        assumeThat("получен один автотаргетинг", keywords, Matchers.hasSize(1));
        autotargetingGetItem = keywords.get(0);
    }

    @Test
    public void statisticsSearchTest() {
        assertThat("получили структуру с нулевыми значениями автотаргетинга в новой группе",
                autotargetingGetItem.getStatisticsSearch(),
                beanDifferV5(
                        new StatisticsMap().withClicks(0L).withImpressions(0L).getBean()
                )
        );
    }

    @Test
    public void statisticsNetworkTest() {
        assertThat("получили структуру с нулевыми значениями автотаргетинга в новой группе",
                autotargetingGetItem.getStatisticsNetwork(),
                beanDifferV5(
                        new StatisticsMap().withClicks(0L).withImpressions(0L).getBean()
                )
        );
    }
}
