package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 26.12.16.
 * https://st.yandex-team.ru/TESTIRT-10841
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Stories(ApiStories.STATUS)
@Issue("https://st.yandex-team.ru/DIRECT-57834")
@Description("Проверка что ServingStatus отдается правильно")
@RunWith(Parameterized.class)
public class GetBsRarelyLoadedTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT;
    private static long adGroupId;
    private static long keywordId;
    private static Long autotargetingId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);


    @Parameterized.Parameter(0)
    public boolean bsRarelyLoaded;

    @Parameterized.Parameter(1)
    public ServingStatusEnum expectedServingStatus;

    @Parameterized.Parameters(name = "{1}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][] {
                {true, ServingStatusEnum.RARELY_SERVED},
                {false, ServingStatusEnum.ELIGIBLE}
        });
    }

    @BeforeClass
    public static void prepare() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Before
    public void setRarelyServedStatus() {
        jooqDbSteps.adGroupsSteps().setBsRarelyLoaded(adGroupId, bsRarelyLoaded);
    }

    @Test
    public void checkKeywordServingStatus() {
        List<KeywordGetItem> keywordGetItems = api.userSteps.keywordsSteps().keywordsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap()
                            .withIds(keywordId))
                        .withFieldNames(KeywordFieldEnum.SERVING_STATUS)
        );
        assumeThat("получили одну фразу", keywordGetItems, hasSize(1));
        assertThat("вернулось правильное значение ServingStatus", keywordGetItems.get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }

    @Test
    public void checkRelevanceMatchServingStatus() {
        List<KeywordGetItem> keywordGetItems = api.userSteps.keywordsSteps().keywordsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordsSelectionCriteriaMap()
                                .withIds(autotargetingId))
                        .withFieldNames(KeywordFieldEnum.SERVING_STATUS)
        );
        assumeThat("получили один автотаргетинг", keywordGetItems, hasSize(1));
        assertThat("вернулось правильное значение ServingStatus", keywordGetItems.get(0).getServingStatus(),
                equalTo(expectedServingStatus));
    }
}
