package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 11.07.16.
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Не должны получать данные кампаний типа: mcb, market, geo, wallet, mcbanner")
@Issue("https://st.yandex-team.ru/DIRECT-46973")
@RunWith(Parameterized.class)
public class GetInvalidCampaignTypeTest {
    private static String LOGIN = KeywordsLogins.SINGLE_CLIENT_GET;
    private static Long campaignId;
    private static Long adGroupId;
    private static Long keywordId;
    private static Long autotargetingId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO},
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.WALLET},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
    }

    @Test
    public void getKeywordsByCampaignId() {
        List<KeywordGetItem> keywords =
                api.userSteps.keywordsSteps().keywordsGetByCampaignId(campaignId.intValue());
        assertThat("ключевые слова и автотаргетинг не получены", keywords, hasSize(0));
    }

    @Test
    public void getKeywordsByAdGroupId() {
        List<KeywordGetItem> keywords =
                api.userSteps.keywordsSteps().keywordsGetByAdGroupId(adGroupId);
        assertThat("ключевые слова и автотаргетинг не получены", keywords, hasSize(0));
    }

    @Test
    public void getKeywordsByIdForKeyword() {
        List<KeywordGetItem> keywords =
                api.userSteps.keywordsSteps().keywordsGetById(keywordId);
        assertThat("ключевое слово не получено", keywords, hasSize(0));
    }

    @Test
    public void getKeywordsByIdForAutotargeitng() {
        List<KeywordGetItem> keywords =
                api.userSteps.keywordsSteps().keywordsGetById(autotargetingId);
        assertThat("автотаргетинг не получен", keywords, hasSize(0));
    }

    @Test
    public void getKeywordsById() {
        List<KeywordGetItem> keywords =
                api.userSteps.keywordsSteps().keywordsGetById(keywordId, autotargetingId);
        assertThat("ключевое слово и автотаргетинг не получены", keywords, hasSize(0));
    }
}
