package ru.yandex.autotests.directapi.keywords.get;

import java.math.BigDecimal;
import java.util.List;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(KeywordsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class GetKeywordsCpmBannerTest {

    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long pid;
    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
    }


    @Test
    public void testDefaultBids() {
        long defaultBid = MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue();
        List<Long> keywordIds = api.userSteps.keywordsSteps().keywordsAdd(new KeywordAddMap()
                .defaultKeyword()
                .withAdGroupId(pid)
                .withBid(null)
                .withContextBid(null));
        assumeThat("было создано одно ключевое слово", keywordIds, hasSize(1));
        long keywordId = keywordIds.get(0);

        BidsRecord bidsRecord = dbSteps.bidsSteps().getBidById(keywordId);
        bidsRecord.setPrice(BigDecimal.ZERO).setPriceContext(BigDecimal.ZERO);
        dbSteps.bidsSteps().updateBids(bidsRecord);

        List<KeywordGetItem> response = api.userSteps.keywordsSteps().keywordsGet(new GetRequestMap()
                .withFieldNames(KeywordFieldEnum.BID, KeywordFieldEnum.CONTEXT_BID, KeywordFieldEnum.STRATEGY_PRIORITY)
                .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                        .withIds(keywordId)));

        assertThat("ставки по умолчанию установились верно", response, beanDifferV5(singletonList(
                new KeywordGetItemMap()
                        .withBid(defaultBid)
                        .withContextBid(defaultBid)
                        .withStrategyPriority(PriorityEnum.NORMAL).getBean())));
    }
}
