package ru.yandex.autotests.directapi.keywords.get;


import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 21.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка валидации некорректных значений FieldNames")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsFieldNamesNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsFieldNamesNegativeTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static long keywordID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String[] fieldNames;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldsValue() {
        prepareKeywords();
        Object[][] data = new Object[][]{
                {"Спецсимволы в имени поля", new String[]{"{InvalidNode}"}},
                {"Пустая строка", new String[]{""}},
                {"Поле с маленькой буквы", new String[]{"contextBid"}},
                {"Несуществующее поле", new String[]{"NonExistingField"}},
                {"Корректное и несуществующее поля", new String[]{"Phone", "NonExistingField"}}
        };
        return Arrays.asList(data);
    }

    private static void prepareKeywords() {
        log.info("Подготовим ключевое слово");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        List<Long> ids = api.userSteps.keywordsSteps()
                .keywordsAdd(new KeywordAddMap().shortKeyword().withAdGroupId(groupID).withUserParam1("param1"));
        assumeThat("добавлено одно ключевое слово", ids, hasSize(1));
        keywordID = ids.get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3626")
    public void invalidFieldNamesTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordsSelectionCriteriaMap()
                                .withIds(keywordID))
                        .withFieldNames(fieldNames),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES),
                        "Id, Keyword, State, Status, AdGroupId, CampaignId, Bid, ContextBid, StrategyPriority, " +
                                "UserParam1, UserParam2, Productivity, StatisticsSearch, StatisticsNetwork, " +
                                "ServingStatus, AutotargetingCategories"));
    }
}
