package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 13.05.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка негативных сценариев для полей Limit и Offset")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsLimitOffsetNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsLimitOffsetNegativeTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static Long campaignID;
    private static long groupID;

    private static long keywordID1;
    private static long keywordID2;
    private static long keywordID3;
    private static long keywordID4;
    private static long keywordID5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public Long limit;

    @Parameterized.Parameter(value = 1)
    public Long offset;

    @Parameterized.Parameter(value = 2)
    public String description;

    @Parameterized.Parameter(value = 3)
    public KeywordsSelectionCriteriaMap selectionCriteriaMap;

    @Parameterized.Parameter(value = 4)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "criteria = {2} limit = {0}, offset = {1}")
    public static Collection limitsAndOffsets() {
        prepareKeywords();
        Long[] defaultKeywordIds = new Long[]{keywordID1, keywordID2, keywordID3, keywordID4, keywordID5};
        Object[][] data = new Object[][]{
                //запрос по keywordID
                {0L, 2L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {0L, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {-2l, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {-6l, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {-5l, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {null, -1l, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {null, -6l, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {2l, -3l, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {-2l, -1l, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                //DIRECT-41922
                {10001l, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_CANNOT_BE_MORE, LimitOffsetMap.LIMIT_MAX_LENGTH)},


                //запрос по groupID
                {-5l, null, "groupID",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(groupID),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {2l, -3l, "groupID",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(groupID),
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},

                //запрос по campaignID
                {-5l, null, "campaignID",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(groupID),
                        new Api5Error(4002, Api5ErrorDetails.KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0)},
                {2l, -3l, "campaignID",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(groupID),
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
        };
        return Arrays.asList(data);
    }

    private static void prepareKeywords() {
        log.info("Подготовим ключевые слова");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        keywordID1 = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        keywordID2 = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        keywordID3 = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        keywordID4 = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
        keywordID5 = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Before
    public void clearUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3628")
    public void getKeywordsLimitOffsetTest() {
        api.userSteps.keywordsSteps().shouldGetKeywordErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(selectionCriteriaMap)
                        .withPage(new LimitOffsetMap()
                                .withLimit(limit)
                                .withOffset(offset))
                        .withAllFieldNames(),
                expectedError);
    }

    @AfterClass
    public static void putCampaignToRemove(){
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignID);
    }
}
