package ru.yandex.autotests.directapi.keywords.get;


import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.keywords.GetResponse;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.keywords.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 27.04.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка положительных сценариев для полей Limit и Offset")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsLimitOffsetTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsLimitOffsetTest.class);
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static Long campaignId;
    private static Long adGroupId1;

    private static long keywordID1;
    private static long keywordID2;
    private static long keywordID3;
    private static long keywordID4;
    private static long keywordID5;

    private static Long autotargetingId1;
    private static Long autotargetingId2;
    private static Long autotargetingId3;
    private static Long autotargetingId4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public Long limit;

    @Parameterized.Parameter(value = 1)
    public Long offset;

    @Parameterized.Parameter(value = 2)
    public String description;

    @Parameterized.Parameter(value = 3)
    public KeywordsSelectionCriteriaMap selectionCriteriaMap;

    @Parameterized.Parameter(value = 4)
    public Long[] expectedIds;

    @Parameterized.Parameter(value = 5)
    public Long expectedLimitedBy;

    private GetResponse getResponse;

    @Parameterized.Parameters(name = "criteria = {2} limit = {0}, offset = {1}")
    public static Collection limitsAndOffsets() {
        prepareKeywords();
        Long[] defaultKeywordIds = new Long[]{keywordID1, keywordID2, keywordID3, keywordID4, keywordID5};
        Long[] autotargetingIds = new Long[]{autotargetingId1, autotargetingId2, autotargetingId3, autotargetingId4};
        Long[] mixedIds = new Long[]{keywordID1, keywordID3, keywordID5, autotargetingId2, autotargetingId4};
        Long[] adGroup1KeywordIds = new Long[]{keywordID1, keywordID2, keywordID3, keywordID4, keywordID5, autotargetingId1};
        Long[] allKeywordIds = new Long[]{keywordID1, keywordID2, keywordID3, keywordID4, keywordID5, autotargetingId1, autotargetingId2, autotargetingId3, autotargetingId4};
        KeywordsSelectionCriteriaMap autotargetingIdsSelectionCriteriaMap = new KeywordsSelectionCriteriaMap().withIds(autotargetingIds);
        KeywordsSelectionCriteriaMap mixedIdsSelectionCriteriaMap = new KeywordsSelectionCriteriaMap().withIds(mixedIds);
        Object[][] data = new Object[][]{
                {null, null, "keywordID", mixedIdsSelectionCriteriaMap, mixedIds, null},
                {5L, null, "keywordID", mixedIdsSelectionCriteriaMap, mixedIds, null},
                {3L, null, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{keywordID1, keywordID3, keywordID5}, 3L},
                {null, 2L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{keywordID5, autotargetingId2, autotargetingId4}, null},
                {null, 6L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[0], null},
                {2L, 5L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[0], null},
                {null, 0L, "keywordID", mixedIdsSelectionCriteriaMap, mixedIds, null},
                {2L, null, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{keywordID1, keywordID3}, 2L},
                {2L, 2L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{keywordID5, autotargetingId2}, 4L},
                {1L, 4L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{autotargetingId4}, null},
                {2L, 4L, "keywordID", mixedIdsSelectionCriteriaMap, new Long[]{autotargetingId4}, null},

                {null, null, "keywordID", autotargetingIdsSelectionCriteriaMap, autotargetingIds, null},
                {4L, null, "keywordID", autotargetingIdsSelectionCriteriaMap, autotargetingIds, null},
                {3L, null, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId1, autotargetingId2, autotargetingId3}, 3L},
                {null, 2L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId3, autotargetingId4}, null},
                {null, 6L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[0], null},
                {2L, 5L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[0], null},
                {null, 0L, "keywordID", autotargetingIdsSelectionCriteriaMap, autotargetingIds, null},
                {1L, null, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId1}, 1L},
                {2L, 1L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId2,autotargetingId3}, 3L},
                {1L, 3L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId4}, null},
                {2L, 3L, "keywordID", autotargetingIdsSelectionCriteriaMap, new Long[]{autotargetingId4}, null},

                //запрос по keywordID
                {null, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        defaultKeywordIds, null},
                {7L, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        defaultKeywordIds, null},
                {4L, null, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[]{keywordID1, keywordID2, keywordID3, keywordID4}, 4l},
                {null, 2L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[]{keywordID3, keywordID4, keywordID5}, null},
                {null, 6L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[0], null},
                {null, 5L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[0], null},
                {null, 0L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        defaultKeywordIds, null},
                {3L, 1L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[]{keywordID2, keywordID3, keywordID4}, 4l},
                {1L, 5L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[0], null},
                {4L, 3L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(defaultKeywordIds),
                        new Long[]{keywordID4, keywordID5}, null},
                {4L, 2L, "keywordID",
                        new KeywordsSelectionCriteriaMap().withIds(
                                keywordID1, keywordID2, keywordID3, keywordID5, keywordID4),
                        new Long[]{keywordID3, keywordID5, keywordID4}, null},

                //запрос по adGroupId1
                {null, null, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        adGroup1KeywordIds, null},
                {7L, null, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        adGroup1KeywordIds, null},
                {4L, null, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[]{keywordID1, keywordID2, keywordID3, keywordID4}, 4L},
                {null, 2L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[]{keywordID3, keywordID4, keywordID5, autotargetingId1}, null},
                {null, 6L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[0], null},
                {null, 5L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[]{autotargetingId1}, null},
                {null, 0L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        adGroup1KeywordIds, null},
                {3L, 1L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[]{keywordID2, keywordID3, keywordID4}, 4L},
                {1L, 6L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[0], null},
                {4L, 3L, "adGroupId1",
                        new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId1),
                        new Long[]{keywordID4, keywordID5, autotargetingId1}, null},

                //запрос по campaignId
                {null, null, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        allKeywordIds, null},
                {10L, null, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        allKeywordIds, null},
                {4L, null, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{keywordID1, keywordID2, keywordID3, keywordID4}, 4L},
                {null, 2L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{keywordID3, keywordID4, keywordID5, autotargetingId1, autotargetingId2, autotargetingId3, autotargetingId4}, null},
                {null, 9L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[0], null},
                {null, 8L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{autotargetingId4}, null},
                {null, 0L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        allKeywordIds, null},
                {3L, 1L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{keywordID2, keywordID3, keywordID4}, 4L},
                {1L, 5L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{autotargetingId1}, 6L},
                {4L, 3L, "campaignId",
                        new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId),
                        new Long[]{keywordID4, keywordID5, autotargetingId1, autotargetingId2}, 7L}
        };
        return Arrays.asList(data);
    }

    private static void prepareKeywords() {
        log.info("Подготовим ключевые слова");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId3 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId4 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        keywordID1 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        keywordID2 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        keywordID3 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        keywordID4 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        keywordID5 = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);

        autotargetingId1 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId1);
        autotargetingId2 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId2);
        autotargetingId3 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId3);
        autotargetingId4 = api.userSteps.keywordsSteps().addAutotargeting(adGroupId4);
    }

    @Before
    public void getKeywords(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        getResponse = api.userSteps.keywordsSteps().keywordsGetRawResponse(
                new GetRequestMap()
                        .withSelectionCriteria(selectionCriteriaMap)
                        .withFieldNames(KeywordFieldEnum.ID)
                        .withPage(new LimitOffsetMap()
                                .withLimit(limit)
                                .withOffset(offset)));
        assumeThat("получили результат запроса ключевых слов", getResponse.getKeywords(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3629")
    public void limitOffsetTest() {
        assertThat("вернулся корректный набор ключевых слов",
                extract(getResponse.getKeywords(), on(KeywordGetItem.class).getId()),
                containsInAnyOrder(expectedIds));
    }

    @Test
    @Title("DIRECT-41965")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3630")
    public void limitedByTest() {
        assertThat("значение параметра LimitedBy", getResponse.getLimitedBy(), equalTo(expectedLimitedBy));
    }

    @AfterClass
    public static void putCampaignToRemove(){
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignId);
    }
}
