package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 28.07.17.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-66999")
@Description("Получение ключевых слов из группы mcbanner")
@RunWith(Parameterized.class)
public class GetKeywordsMcbannerTest {
    private static final String CLIENT = KeywordsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String title;

    @Parameterized.Parameter(1)
    public KeywordsSelectionCriteriaMap criteriaMap;

    @Parameterized.Parameters(name = "Попытка получение ключевого слова по {0}")
    public static Collection dataSet() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MCBANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, PhrasesAdgroupType.mcbanner);

        Object[][] data = new Object[][]{
                {"номеру кампании", new KeywordsSelectionCriteriaMap().withCampaignIds(campaignId)},
                {"номеру группы", new KeywordsSelectionCriteriaMap().withAdGroupIds(adGroupId)},
                {"номеру ключевого слова", new KeywordsSelectionCriteriaMap().withIds(keywordId)},
        };
        return Arrays.asList(data);
    }

    @Test
    public void getKeywordsFromMcbannerTest() {
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGet(criteriaMap);
        assertThat("вернулся корректный набор визиток", keywords, emptyIterable());
    }

}
