package ru.yandex.autotests.directapi.keywords.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 14.05.15
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Получение ключевых слов от имени внутренних ролей")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsRolesAccessTest {
    private static LogSteps log = LogSteps.getLogger(GetKeywordsRolesAccessTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String keywordCreator;

    @Parameterized.Parameter(1)
    public String keywordGetter;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Matcher expectedResult;

    @Parameterized.Parameters(name = "creator = {0}, getter = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, KeywordsLogins.SERV_CLIENT,
                        hasSize(1)},
                {KeywordsLogins.AGENCY, KeywordsLogins.AGENCY, KeywordsLogins.SUBCLIENT,
                        hasSize(1)},
                {KeywordsLogins.AGENCY_REP, KeywordsLogins.AGENCY_REP, KeywordsLogins.SUBCLIENT,
                        hasSize(1)},
                {KeywordsLogins.AGENCY, KeywordsLogins.AGENCY_REP, KeywordsLogins.SUBCLIENT,
                        hasSize(1)},
                {KeywordsLogins.AGENCY, KeywordsLogins.SUBCLIENT, KeywordsLogins.SUBCLIENT,
                        hasSize(1)},

                {Logins.SUPER_LOGIN, Logins.PLACER, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, KeywordsLogins.SINGLE_CLIENT_GET, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, KeywordsLogins.SINGLE_CLIENT_REP, KeywordsLogins.SINGLE_CLIENT,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.MEDIA, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, KeywordsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)}
        });
    }

    private long keywordID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(keywordGetter);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(keywordCreator);

        log.info("Создадим кампанию, группу и ключевое слово от имени " + keywordCreator);
        api.as(keywordCreator);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(client, groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3634")
    public void getKeywordRolesTest() {
        log.info("Запросим ключевое слово от имени " + keywordGetter);
        api.as(keywordGetter);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(client, keywordID);
        assertThat("получили ключевое слово ролью", keywords, expectedResult);
    }
}
