package ru.yandex.autotests.directapi.keywords.get;


import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.keywords.KeywordsFeatures;
import ru.yandex.autotests.directapi.keywords.KeywordsLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 27.05.2015.
 */
@Aqua.Test
@Features(KeywordsFeatures.GET)
@Description("Проверка выдачи полного набора State, предусмотренных в сервисе")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetKeywordsStateTest {
    private static final String client = KeywordsLogins.SINGLE_CLIENT_GET;

    private static long keywordID;
    private static long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public int isSuspended;

    @Parameterized.Parameter(value = 1)
    public BidsStatusmoderate statusModerate;

    @Parameterized.Parameter(value = 2)
    public StateEnum expectedState;

    @Parameterized.Parameters(name = "suspended = {0}, moderate = {1}, expected state = {2}")
    public static Collection stateValues() {
        Object[][] data = new Object[][]{
                {0, BidsStatusmoderate.Yes, StateEnum.ON},
                {1, BidsStatusmoderate.Yes, StateEnum.SUSPENDED},
                {0, BidsStatusmoderate.No, StateEnum.OFF},
                {1, BidsStatusmoderate.No, StateEnum.SUSPENDED},
                {0, BidsStatusmoderate.New, StateEnum.OFF},
                {1, BidsStatusmoderate.New, StateEnum.SUSPENDED}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3642")
    public void keywordStateOnTest() {
        api.userSteps.keywordsSteps().setKeywordState(groupID, keywordID, isSuspended, statusModerate);
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordID);
        assumeThat("получено ключевое слово", keywords, hasSize(1));

        assertThat("значение State", keywords.get(0).getState(), equalTo(expectedState));
    }
}
